/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.VariableResolvers;

@FunctionalInterface
public interface Parser<T, C extends Context> {
    public T parse(DocNode var1, C var2) throws ConfigValidationException;

    public static interface Context {
        public static final Basic DEFAULT = new Basic(null, false, false);

        public VariableResolvers variableResolvers();

        default public boolean isLenientValidationRequested() {
            return false;
        }

        default public boolean isExternalResourceCreationEnabled() {
            return false;
        }

        public static Basic get() {
            return DEFAULT;
        }

        public static Basic lenient() {
            return new Basic(null, true, false);
        }

        public static Basic withExternalResources() {
            return new Basic(null, false, true);
        }

        public static Basic variableResolvers(VariableResolvers variableResolvers) {
            return new Basic(variableResolvers, false, false);
        }

        public static class Basic
        implements Context {
            private final VariableResolvers variableResolvers;
            private final boolean lenientValidationRequested;
            private final boolean externalResourceCreationEnabled;

            Basic(VariableResolvers variableResolvers, boolean lenientValidationRequested, boolean externalResourceCreationEnabled) {
                this.variableResolvers = variableResolvers;
                this.lenientValidationRequested = lenientValidationRequested;
                this.externalResourceCreationEnabled = externalResourceCreationEnabled;
            }

            @Override
            public VariableResolvers variableResolvers() {
                return this.variableResolvers;
            }

            @Override
            public Basic variableResolvers(VariableResolvers variableResolvers) {
                return new Basic(variableResolvers, this.lenientValidationRequested, this.externalResourceCreationEnabled);
            }

            @Override
            public boolean isLenientValidationRequested() {
                return this.lenientValidationRequested;
            }

            @Override
            public Basic lenient() {
                return new Basic(this.variableResolvers, true, this.externalResourceCreationEnabled);
            }

            @Override
            public boolean isExternalResourceCreationEnabled() {
                return this.externalResourceCreationEnabled;
            }

            @Override
            public Basic withExternalResources() {
                return new Basic(this.variableResolvers, this.lenientValidationRequested, true);
            }
        }
    }

    @FunctionalInterface
    public static interface ReturningValidationResult<T, C extends Context> {
        public ValidationResult<T> parse(DocNode var1, C var2);
    }
}

